;Segments declarations for stdlib32.lib. Change it if you need to

;Stuff you can define (through the assembler or put here)
;UNICODE                equ     1        ;Uncomment for UNICODE strings
;TASM                   equ     1        ;Uncomment for TASM

        .386
        .model  flat,stdcall

signed          equ     0001h           ;eax is a signed number
showsign        equ     0002h           ;always show '+' or '-'
bighex          equ     0004h           ;big hex characters (A-F) (ntoa:proc)

ifdef TASM
        locals  @@
endif

ifdef UNICODE
  lodsb_        equ     LODSW
  stosb_        equ     STOSW
  al_           equ     AX
  CharSize      equ     02h
  CharType      equ     WORD
else
  lodsb_        equ     LODSB
  stosb_        equ     STOSB
  al_           equ     AL
  CharSize      equ     01h
  CharType      equ     BYTE
endif

;This macro will use the right win32 procedure name depending on
;if it's unicode or not
extrnp  macro   p1,p2,p3,p4,p5,p6,p7,p8,p9
  ifdef UNICODE
    irp pX,<p1,p2,p3,p4,p5,p6,p7,p8,p9>
      ifb <pX>
        exitm
      endif
        ifdef TASM
          extrn &&pX&&W:near
          pX    equ     &&pX&&W
        else
          extrn &pX&W:near
          pX    equ     &pX&W
        endif
    endm
  else
    irp pX,<p1,p2,p3,p4,p5,p6,p7,p8,p9>
      ifb <pX>
        exitm
      endif
        ifdef TASM
          extrn &&pX&&A:near
          pX    equ     &&pX&&A
        else
          extrn &pX&A:near
          pX    equ     &pX&A
        endif
    endm
  endif
endm

startcode       macro
        .code
endm
endcode         macro
endm

startconst      macro
        .const
endm
endconst        macro
endm

startdata       macro
        .data
endm
enddata         macro
endm

startbss        macro
        .data?
endm
endbss          macro
endm

        startcode
        endcode
        startconst
        endconst
        startdata
        enddata
        startbss
        endbss
